CREATE OR REPLACE VIEW public.v_cupomfiscal_cartao
AS SELECT vd.cd_emp,
    vd.cd_filial,
    vd.dt_vd,
    COALESCE(vd.dt_cad, vd.dt_vd) AS dt_cad,
    COALESCE(vd.dt_cad, vd.hr_vd) AS hr_vd,
    vd.cd_cx,
    vd.cd_vd,
    vd.nr_ecf,
    vd.st_vd,
        CASE
            WHEN COALESCE(tef.cd_adm_cartao, 0::numeric) > 0::numeric THEN tef.cd_adm_cartao
            WHEN tef.cd_adm_cartao = 0::numeric AND tef.tp_adm = 6 THEN ( SELECT rc_adm_cartao.cd_adm_cartao
               FROM rc_adm_cartao
              WHERE rc_adm_cartao.cd_emp = tef.cd_emp AND rc_adm_cartao.tp_adm = tef.tp_adm::numeric AND rc_adm_cartao.parc = tef.qt_parc::numeric AND rc_adm_cartao.sts_adm = 0
             LIMIT 1)
            ELSE NULL::numeric
        END AS cd_conv,
        CASE
            WHEN COALESCE(tef.cd_adm_cartao, 0::numeric) > 0::numeric THEN adm.nm_usual
            WHEN tef.cd_adm_cartao = 0::numeric AND tef.tp_adm = 6 THEN ( SELECT rc_adm_cartao.nm_usual
               FROM rc_adm_cartao
              WHERE rc_adm_cartao.cd_emp = tef.cd_emp AND rc_adm_cartao.tp_adm = tef.tp_adm::numeric AND rc_adm_cartao.parc = tef.qt_parc::numeric AND rc_adm_cartao.sts_adm = 0
             LIMIT 1)
            ELSE NULL::character varying
        END AS nm_conv,
    tef.vl_cartao AS vlr_cartao,
    tef.vl_saque_cartao AS vlr_saque,
        CASE
            WHEN tef.qt_parc > 0 THEN tef.qt_parc::numeric
            ELSE adm.parc
        END AS qt_parc,
    tef.cod_rede,
    tef.cod_bandeira,
        CASE
            WHEN tef.cod_modalidade::text = ''::text THEN '0'::character varying
            ELSE tef.cod_modalidade
        END AS cod_modalidade,
    tef.tp_adm AS tp_administradora,
        CASE
            WHEN COALESCE(
            CASE
                WHEN tef.nsu_tef = 0::numeric THEN NULL::numeric
                ELSE tef.nsu_tef
            END, 0::numeric) > 0::numeric AND
            CASE
                WHEN tef.nsu_tef = 0::numeric THEN NULL::numeric
                ELSE tef.nsu_tef
            END <> 1::numeric THEN tef.nsu_tef
            WHEN
            CASE
                WHEN tef.nsu_tef = 0::numeric THEN NULL::numeric
                ELSE tef.nsu_tef
            END = 1::numeric THEN tef.cd_trn_tef
            WHEN COALESCE(
            CASE
                WHEN tef.nsu_tef = 0::numeric THEN NULL::numeric
                ELSE tef.nsu_tef
            END, 0::numeric) = 0::numeric THEN tef.cd_trn_tef
            ELSE NULL::numeric
        END AS nr_transacao,
        CASE
            WHEN COALESCE(tef.nr_autorizacao, '0'::character varying)::text > '0'::text AND tef.nr_autorizacao::text <> '1'::text THEN tef.nr_autorizacao
            WHEN tef.nr_autorizacao::text = '1'::text THEN tef.cd_trn_tef::character varying
            WHEN tef.nr_autorizacao::text = '0'::text THEN tef.cd_trn_tef::character varying
            ELSE NULL::character varying
        END AS nr_autorizacao,
    tef.ds_bandeira AS bandeira,
    COALESCE(tef.nr_estabelecimento, ''::character varying) AS nr_estabelecimento,
    COALESCE(tef.nr_comprovante, ''::character varying) AS nr_comprovante,
        CASE
            WHEN tef.gerenciador_tef = 1 THEN 'SCOPE'::character varying
            WHEN tef.trn_pos = 1 THEN 'POS'::character varying
            ELSE 'SITEF'::character varying
        END AS tef_gateway,
    COALESCE(vd.flag_consolidado, 0) AS flag_consolidado
   FROM pdv_vd vd
     JOIN pdv_vd_tef tef ON vd.cd_emp = tef.cd_emp AND vd.cd_filial = tef.cd_filial AND vd.cd_vd = tef.cd_vd
     LEFT JOIN rc_adm_cartao adm ON tef.cd_emp = adm.cd_emp AND tef.cd_adm_cartao = adm.cd_adm_cartao
  WHERE tef.vl_cartao > 0::numeric AND (adm.tp_adm <> 6::numeric OR tef.cd_adm_cartao = 0::numeric);
